<?php
require_once __DIR__ . '/config.php';
$input = json_decode(file_get_contents('php://input'), true);
$product_id = trim($input['product_id'] ?? '');

if ($product_id === '') { echo json_encode(['ok'=>false,'message'=>'Missing product_id']); exit; }

$stmt = $pdo->prepare("SELECT p.*, c.name, c.mobile, c.email FROM products p
  JOIN customers c ON c.customer_id = p.customer_id WHERE p.product_id=?");
$stmt->execute([$product_id]);
$prod = $stmt->fetch();
if (!$prod) { echo json_encode(['ok'=>false,'message'=>'Product not found']); exit; }

$today = today_date();
$renew_date = new DateTime($prod['renew_date']);
$today_dt = new DateTime($today);

$overdue_days = 0;
if ($today_dt > $renew_date) {
  $overdue_days = (int)$renew_date->diff($today_dt)->days;
}

$base = (float)$prod['base_price'];
$gst  = round($base * 0.18, 2);
$cgst = round($base * 0.09, 2);
$sgst = round($base * 0.09, 2);

$interest = 0.0;
// Rule: interest only if overdue > 7 days => fixed 7 * interest_per_day
if ($overdue_days > 7) {
  $interest = 7 * (float)$prod['interest_per_day'];
}

$total = round($base + $gst + $interest, 2);

echo json_encode([
  'ok'=>true,
  'today'=>$today,
  'overdue_days'=>$overdue_days,
  'customer'=>['name'=>$prod['name'], 'mobile'=>$prod['mobile'], 'email'=>$prod['email']],
  'product'=>[
    'product_id'=>$prod['product_id'],
    'product_name'=>$prod['product_name'],
    'customer_id'=>$prod['customer_id'],
    'base_price'=>(float)$prod['base_price'],
    'renew_date'=>$prod['renew_date'],
    'interest_per_day'=>(float)$prod['interest_per_day'],
    'payment_term_days'=>(int)$prod['payment_term_days']
  ],
  'amounts'=>[
    'base'=>$base, 'gst'=>$gst, 'cgst'=>$cgst, 'sgst'=>$sgst, 'interest'=>$interest, 'total'=>$total
  ]
]);
