<?php
require_once __DIR__ . '/config.php';
session_start();

$input = json_decode(file_get_contents('php://input'), true);
$payment_id = $input['razorpay_payment_id'] ?? '';
$order_id   = $input['razorpay_order_id'] ?? '';
$signature  = $input['razorpay_signature'] ?? '';
$product_id = trim($input['product_id'] ?? '');
$chosen_term_days = (int)($input['chosen_term_days'] ?? 30);

if (!$payment_id || !$order_id || !$signature) {
  echo json_encode(['ok'=>false,'message'=>'Missing payment fields']); exit;
}
if (!isset($_SESSION['pending_payment']) || $_SESSION['pending_payment']['order_id'] !== $order_id) {
  echo json_encode(['ok'=>false,'message'=>'Order mismatch / session expired']); exit;
}

// Verify signature
$generated_signature = hash_hmac('sha256', $order_id . '|' . $payment_id, RAZORPAY_KEY_SECRET);
if (!hash_equals($generated_signature, $signature)) {
  echo json_encode(['ok'=>false, 'message'=>'Signature verification failed']); exit;
}

// Update renew date = today + chosen_term_days
$stmt = $pdo->prepare("SELECT * FROM products WHERE product_id=? LIMIT 1");
$stmt->execute([$product_id]);
$prod = $stmt->fetch();
if (!$prod) { echo json_encode(['ok'=>false,'message'=>'Product not found']); exit; }

$today = today_date();
$dt = new DateTime($today, new DateTimeZone('Asia/Kolkata'));
$dt->modify('+' . $chosen_term_days . ' days');
$new_renew_date = $dt->format('Y-m-d');

$upd = $pdo->prepare("UPDATE products SET renew_date = ?, payment_term_days = ? WHERE product_id=?");
$upd->execute([$new_renew_date, $chosen_term_days, $product_id]);

unset($_SESSION['pending_payment']);

echo json_encode(['ok'=>true, 'new_renew_date'=>$new_renew_date]);
